import matplotlib.pyplot as plt
import seaborn as sns
import os
from sklearn.preprocessing import LabelEncoder
from sklearn.model_selection import train_test_split
from sklearn.metrics import classification_report, confusion_matrix
from sklearn.linear_model import LogisticRegression
from sklearn.metrics import accuracy_score
from sklearn.preprocessing import StandardScaler
from sklearn.cluster import KMeans
from sklearn.metrics import silhouette_score
import numpy as np
from scipy import stats
import sys
sys.path.append(sys.argv[1])



import pandas as pd   
import pickle

# Read the fastfood data
fastfood = pd.read_csv(os.path.join(sys.argv[1], 'fastfood.csv'))

# Define the thresholds
max_calories = 500
max_total_fat = 20
max_sodium = 800
max_sugar = 15
min_protein = 10
 
# Create healthy and unhealthy dataframes
healthy_items = fastfood[(fastfood['calories'] <= max_calories) &
                         (fastfood['total_fat'] <= max_total_fat) &
                         (fastfood['sodium'] <= max_sodium) &
                         (fastfood['sugar'] <= max_sugar) &
                         (fastfood['protein'] >= min_protein)] 
 
unhealthy_items = fastfood[~fastfood.index.isin(healthy_items.index)]

print(unhealthy_items)
pickle.dump(unhealthy_items,open("./ref_result/unhealthy_items.pkl","wb"))
